#include <bits/stdc++.h>
using namespace std;

struct Ponco {
    int idx;
    long long w, v;
    double ratio;
};

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int N;
    long long W;
    double eps;
    cin >> N >> W >> eps;

    vector<Ponco> a(N);
    for (int i = 0; i < N; i++) {
        cin >> a[i].w >> a[i].v;
        a[i].idx = i + 1;
        a[i].ratio = (double)a[i].v / a[i].w;
    }

    sort(a.begin(), a.end(), [](const Ponco &x, const Ponco &y) {
        return x.ratio > y.ratio;
    });

    long long curW = 0;
    vector<int> chosen;

    for (const auto &p : a) {
        if (curW + p.w <= W) {
            curW += p.w;
            chosen.push_back(p.idx);
        }
    }

    cout << chosen.size() << "\n";
    for (int i = 0; i < (int)chosen.size(); i++) {
        cout << chosen[i] << (i + 1 < (int)chosen.size() ? ' ' : '\n');
    }

    return 0;
}